#include "General.h"
#include "KillHarvesterConsoleCommands.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "engine_game.h"
#include "gmgame.h"
#include "Iterator.h"
#include "GameObjManager.h"
#include "SmartGameObj.h"

#define GDI 1
#define NOD 0

void Kill_Harvester(int Team)
{
	SLNode<SmartGameObj> *x = GameObjManager::SmartGameObjList.Head();
	while (x)
	{
		GameObject *o = x->Data();
		if (o)
		{
			if (o->As_VehicleGameObj())
			{
				int TeamType = Commands->Get_Player_Type(o);
				if (TeamType == Team)
				{
					if (Is_Harvester(o) || Is_Harvester_Preset(o))
					{
						Commands->Apply_Damage(o,99999,"Death",0);
					}					
				}
			}
		}
		x = x->Next();
	}
}

class CommandKILLHARVNOD :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "killharvnod"; 
	}
	const char* Get_Help() 
	{ 
		return "KILLHARVNOD - Destroys the Nod Tiberium Harvester."; 
	}
	void Activate(const char* argumentsString)
	{
		Kill_Harvester(NOD);
	}
};

class CommandKILLHARVGDI :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "killharvgdi"; 
	}
	const char* Get_Help() 
	{ 
		return "KILLHARVGDI - Destroys the GDI Tiberium Harvester."; 
	}
	void Activate(const char* argumentsString)
	{
		Kill_Harvester(GDI);
	}
};


class KILLHARVESTERCONSOLECOMMANDS : public Plugin
{
public:
	KILLHARVESTERCONSOLECOMMANDS()
	{
		ConsoleFunctionList.Add(new CommandKILLHARVNOD);
		ConsoleFunctionList.Add(new CommandKILLHARVGDI);
		Sort_Function_List();
		Verbose_Help_File();
	}
	~KILLHARVESTERCONSOLECOMMANDS()
	{
		const DynamicVectorClass<ConsoleFunctionClass*> consoleFunctions(ConsoleFunctionList);
		TT_FOREACH(consoleFunction, consoleFunctions)
		{
			const char* name = (*consoleFunction)->Get_Name();
			if (name)
			{ 
				if (strcmp(name, "killharvnod") == 0 || strcmp(name, "killharvgdi") == 0)
				{
					ConsoleFunctionList.Delete(consoleFunction);
				}
			}
		}
	}	
};

KILLHARVESTERCONSOLECOMMANDS killharvesterconsolecommands;


extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &killharvesterconsolecommands;
}